; microtonal - tsh/PVM|rebelion.digital|br
; a 256b msdos intro for flashparty 2021
; --------------------------------------
; Microtonal music or microtonality is the use in music of 
; microtones—intervals smaller than a semitone, also called "microintervals". 
; It may also be extended to include any music using intervals not found in 
; the customary Western tuning of twelve equal intervals per octave.
;
; In OPL, the frequency table needed for setting correctly the notes from Db to C is 
; simply too big for a 256b production ( 12 words! )
; Also, setting registers, operators, notes progression, instruments, etc... 
; in this reduced space is a challenge.
; The generation of notes must be done programatically to chop off those 
; precious bytes. And this generation of the table creates a slight detune 
; per each iteration due to the "approximation" algorithm. 
; Therefore, this "approximation" generates an out of tune frequency table, or 
; better put a "microtonal" frequency table ;D 
;
; This prod is focused on adlib and trying to reduce as much as possible the 
; setup of OPL registers.
; I am pretty sure that there is a LOT of room for improvement,
; and I'd love to see more on the adlib side and throw away MIDI for good! :) 
; 
; I've learned a lot from the latest sizecoding prods and I've been heavily 
; "inspired" by marquee design. 
; Thanks to the people of the Sizecoding discord server!
;
; Greetz to:
; the cr0cz, rebelion.digital, pvm, cybercirujas, blackriders,
; k2, marquee design, hellmood, sensenstahl, rrrola, superogue,
; the sizecoding people of discord, and you!
; -----
 
CHANNEL equ 0x00
FREQ_LOW                            equ 0xa0 + CHANNEL
FREQ_HIGH_KEYON_OCTAVE              equ 0xb0 + CHANNEL
FEEDBACK_STRENGTH_CONN_TYPE         equ 0xC0 + CHANNEL

org 100h

ADLIB_ADDR_PORT equ 0x0388
ADLIB_ADDR_DATA equ 0x0389

; set up the counter label here.
; this will end to be dead code anyways and
; overwriting later on the first instructions 
; after executing them is ok
; --------------
; Dead Code Zone
; --------------

counter:

gen_notes_frequencies:

    ; if you substract each note from the real frequency table
    ; you'll notice that there is 16 to 19 elements of distance
    ; between each element. 

    ; the notes generated by this algorithm 
    ; are going to generate very-near frequencies
    ; from the correct ones, so the notes will be actually
    ; a bit out of tune. But we can argue that this is actually
    ; NOT out of tune but a microtonal OPL music approach ;D

    mov ax, 0x16b   ; (Note Db)
    mov cl, 12      ; 12 notes ; assuming cx = 0, saving 1 byte
    mov di, notes
        .loop1:
        stosw
        add al, 16  ; distance between notes
        loop .loop1

; No initialization of OPL3 and settings - OPL2 only!

adlib_set_instrument:

    ; adlib_write requires: 
    ; al - reg
    ; bl - val
    ; from the previous loop, cx is 0
    ; so we initialize the counter with cl, saving 1 byte!
    mov cl, 10  ; 10 values for carrier and modulator
    mov si, instrument_data
        .loop1:
        lodsw
        mov bl, ah
        call adlib_write
        loop .loop1

;xor cl, cl ; counter steps
; the counter is going to be zero anyways because of the 
; previous loop

les bp,[bx]
mov gs, bp

; set video mode 13
mov al, 0x13
int 0x10

; copy text
mov ah, 9
mov dx, text
int 21h ; print text into mode 13 
        ; we'll copy screen data later
mov fs, ax
vcopy:
    inc ch
hcopy:
    es lodsb
    mov byte[fs:bx], al
    inc bx
    loop hcopy

add si, 64

jnc vcopy
mov bp, si

; -------------------------------------
; draw (end of Dead Code Zone)
; -------------------------------------

draw_frame:
    mov ax, 0cccdh
    mul di
    sub dx, 6480h

	mov cx,bp
	add al,cl
	shr cx,3    ; "scenes" change speed
	and al,cl

	; drawtext
	and cl,0ffh
	mov bx,dx
	add bh,cl
	shl bl, 1	    ; font size - horizontal
	add bl, 127     ; "thickness"
	add dh,byte [fs:bx-(80*256*2)-(128+64)] 
	xor al,dh
    
    ; save pixel 
    shr cx, 4
	and al,16
	add al,cl
	stosb
	inc di
	inc di

    jnz draw_frame
    inc bp

    ; try to trigger adlib cmds slowly
    ; there should be a better way to do this.
    ; counter points at the beginning of the binary
    ; in the "dead code zone"
    mov ax, [counter]
    shl ax, 7   ; speed
    cmp ax, 5
    ja skip_sound  

    ; adlib_key_off 
    ;-> set frequency high byte to zero and you are done, Yes!

    mov al, FREQ_HIGH_KEYON_OCTAVE
    mov bl, 0

    call adlib_write ; stop playing the current note

    ; ah - octave
    ; si - note
    shr cx, 1
    mov ah, cl

    ;mov si, 6    ; with ah 4, --> (E4)
    mov si, cx 
    and si, 0x0a  ; cap 'si' to 0x0a and avoid reading after the frequency table
    call adlib_key_on

    skip_sound:
    ; i don't like this at all.
    ; mmmh....
    inc word [counter]

        
    in al, 0x60     ; exit 
    dec al          ; on ESC
    jnz draw_frame  ; press
    ret

; ---------------
; adlib functions
; ---------------

; adlib_key_on requires:
; ah - octave
; si - note

adlib_key_on:

    ;pusha
        ; set frequency low byte

        mov al, FREQ_LOW
        mov bx, [notes + si]
        ;and bx, 0xff

        call adlib_write

        ; set frequency high byte

        mov al, FREQ_HIGH_KEYON_OCTAVE
        
        ; (fnum >> 8) & 3 -> X (bl)
        ;mov bx, [notes + si]
        shr bx, 8
        and bx, 3
        
        ; (octave << 2) & 0x1c -> Y (ah)
        shl ah, 2
        and ah, 0x1c

        ; 0x20 | X | Y

        or bl, 0x20
        or bl, ah

        call adlib_write

    ;popa
    ret

; adlib_write requires: 
; al - reg
; bl - val

adlib_write: 

    pusha
        mov dx, ADLIB_ADDR_PORT
        out dx, al ; set REGISTER OUT

        mov cx, 6

        .loop1:
            in al, dx  ; reg IN al
            loop .loop1 ; first delay

            inc dx ;    Switch to ADLIB_DATA_PORT 

            mov al, bl  ; bl should have VALUE of previous REGISTER
            out dx, al  ; send VALUE OUT

            mov cx, 36
        
        .loop2:
            in al, dx   ; al should have adlib_reg
            loop .loop2

    popa
    ret

; data

instrument_data:
; OP1 Modulator
db 0x20, 0x87     ; m_am_vib_eg
db 0x40, 0x40     ; m_ksl_volume
db 0x60, 0x81     ; m_attack_decay
db 0x80, 0xf3     ; m_sustain_release
db 0xe0, 0x00     ; m_waveform

; OP1 Carrier
db 0x23, 0xa5     ; c_am_vib_eg
db 0x43, 0x0b     ; c_ksl_volume
db 0x63, 0xf1     ; c_attack_decay
db 0x83, 0x1f     ; c_sustain_release
db 0xe3, 0x00     ; c_waveform

; instrument setup
i_misc: 
;db 0x0e     ; feedback_fm
;db 0x00     ; fine_tune
;db 0x00     ; panning = center
;db 0x00     ; voice_type = Melodic

text: 
db 'pvm^br'
db 10, 10
db 'microtonal'
db 10
db 'fUCK covid$'

notes:
; after this memory position, we can write our generated frequency table
; without reserving any space for it.
; we need to know exactly how our generated data model is going to 
; be used by our program: 
; --------------------------------------
; 12 words  | generated frequencies
; --------------------------------------

; the original notes table is listed below
; ----
; notes from Db to C
;notes:
;dw 0x16b, 0x181, 0x198, 0x1b0, 0x1ca, 0x1e5 
;dw 0x202, 0x220, 0x241, 0x263, 0x287, 0x2ae

